-- Create the execution object
DECLARE @execution_id BIGINT
EXEC [SSISDB].[catalog].[create_execution] 
@package_name=N'30 Parameterized Package.dtsx'
	, @execution_id=@execution_id OUTPUT
	, @folder_name=N'Making the Most of SSIS Catalog'
	, @project_name=N'Making the Most of the Catalog - SSIS'
	, @use32bitruntime=False
	, @reference_id=NULL


-- Set the variable named pFilePath
DECLARE @pFilePath SQL_VARIANT = N'Data Source=.;Initial Catalog=AdventureWorks2012;Provider=SQLNCLI11.1;Integrated Security=SSPI;Auto Translate=False;'
EXEC [SSISDB].[catalog].[set_execution_parameter_value] @execution_id
	, @object_type=20
	, @parameter_name=N'ppConnStr'
	, @parameter_value=@pFilePath

-- Set the system variable for logging level
DECLARE @logLevel SQL_VARIANT = N'e:\Output'
EXEC [SSISDB].[catalog].[set_execution_parameter_value] @execution_id
	, @object_type=30
	, @parameter_name=N'pProcessingFolder'
	, @parameter_value=@logLevel

-- Turn on synchronous execution
EXEC [SSISDB].[catalog].[set_execution_parameter_value] 
        @execution_id,  -- execution_id from catalog.create_execution
        @object_type=50, 
        @parameter_name=N'SYNCHRONIZED', 
        @parameter_value= 1; -- turn on synchronized execution

-- Finally, execute the package
EXEC [SSISDB].[catalog].[start_execution] @execution_id
GO